;PSPECT19.ASM 05JUL01 - COPYRIGHT JOHN BECKER - EPE PIC SPECTRUM ANALYSER

;PIC16F877-20, 20MHz, WDT OFF, POR ON, XTAL HS

;Config register bits (all PIC Toolkit Mk2/TK3 defaults except for OS1 & OS0)
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   1   0   0   1   0
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '87 data sheet.

	list	p=16F877,r=dec
	__config	h'3F32'

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

INDF:    .EQU $00
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04
PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1
PORTD:   .EQU $08  ;page 0
TRISD:   .EQU $08  ;page 1
PORTE:   .EQU $09  ;page 0
TRISE:   .EQU $09  ;page 1
INTCON:  .EQU $0B  ;page 0, 1, 2, 3
ADCON1:  .EQU $1F  ;page 1

MEM:     .EQU $20	; sampling rate flag 
DELAYA: .EQU $26        ; delay for data send to PC
MEMHI:  .EQU $28        ; msb val ADC
MEMLO:  .EQU $29        ; lsb val ADC
WADDRH: .EQU $2A        ; msb of mem address
WADDRL: .EQU $2B        ; lsb of mem address
LIMIT:  .EQU $2C        ; sample limit value
CHANGE: .EQU $2E        ; flag for Change command received from PC
CHANGA: .EQU $2F        ; temp store
LOOPA:  .EQU $30        ;loop counter 1 - general
FOSC:   .EQU $31        ; ADC clock osc rate 0=Fosc/8, 1=Fosc/2;
CHECK:	.EQU $32	; temp 

          ; locations up to $7F are available

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1
Z:      .EQU 2

RP0:    .EQU 5           ;STATUS reg
RP1:    .EQU 6           ;STATUS reg
GIE:    .EQU 7           ;INTCON reg
;GO:     .EQU 2           ;ADCON0 reg

        .ORG $0004      ;Interrupt vector address
        GOTO GIEOFF     ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory

GIEOFF: BCF INTCON,GIE  ;turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

ROUTE:  ADDWF PCL,F
        goto RESETP       ;0  000  PC orig val 000 = 0 RESET
        goto WAITCLR      ; goto CHANAB       ;1  001  PC orig val 100 = 4 both chans
        goto WAITCLR      ; goto CHANA        ;2  010  PC orig val 010 = 2 chan 0
        goto MAX0         ;3  011  PC orig val 110 = 6 ; normal sampling
        goto INCRATE      ;4  100  PC orig val 001 = 1 change ADC sample rate
        goto MAX1         ;5  101  PC orig val 101 = 5 ; slow sampling
        goto WAITCLR      ; goto CHANB        ;6  110  PC orig val 011 = 3 chan 1
        goto MAX2         ;7  111  PC orig val 111 = 7 ; very slow sampling

OUTIT:  ADDWF PCL,F      ;routing for nibble send to PC, etc
        goto SENDLS3     ;0. chan 0 lsb
        goto STEP0       ;1. address step
        goto SENDLS4     ;2. chan 1 lsb
        retlw 1          ;3. nil
        goto SENDMS3     ;4. chan 0 msb
        retlw 2          ;5. nil
        goto SENDMS4     ;6. chan 1 msb
        retlw 1          ;7. nil

;..............

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        movlw %00110011
        movwf PORTA
;        clrf PORTA
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE
        PAGE1
        movlw %00000100     ;RA2 as input, others as output
        movwf TRISA
        clrf TRISB          ;PORTB as output
        clrf TRISC          ;PORTC as output
        movlw %11111111
        movwf TRISD         ;PORTD as input
        movlw %00000111
        movwf TRISE         ;PORTE as input
        movlw %00000110     ;set PORTA, PORTE as digital
        movwf ADCON1
        movlw %00000101     ;timer 1:64 (1/50th sec)
        movwf OPTION
        PAGE0

	clrf FOSC
        movlw %00001000     ;sample limit 2k
        movwf LIMIT
	clrf MEM

;............................ END OF SETUP

INTRPT:  movlw 255         ;main loop start point
         movwf CHANGE
         movlw %00110000   ;mem OE, mem WE, N/A, ADC CLK, OE
                           ;    A5, A4,     A3/2,     A1, A0
         movwf PORTA       ;    1   1        00       0   0
	 movf MEM,F
	 btfss STATUS,Z
	 goto DX1

DX0:     clrf PORTB	   ; fastest route
         movf LIMIT,W
         movwf PORTC
         movlw %00100000   ;mem OE, mem WE, N/A, ADC CLK, OE
                           ;    A5, A4,     A3/2,     A1, A0
                           ;    1   0        00       0   0

WAITADC: bsf PORTA,1       ;toggle ADC clock up:      ;..., down
         movwf PORTA       ; mem WE lo, ADC clock lo
         bsf PORTA,4       ; mem WE up

         incfsz PORTB,F
         goto WAITADC
         decfsz PORTC,F
         goto WAITADC
	 goto SENDPC0

DX1:     clrf PORTB	   ; slow route 
         movf LIMIT,W
         movwf PORTC
         movlw %00100000   ;mem OE, mem WE, N/A, ADC CLK, OE
                           ;    A5, A4,     A3/2,     A1, A0
                           ;    1   0        00       0   0

WAITADC2: bsf PORTA,1      ; ADC clock up
         bcf PORTA,1       ; ADC clock down
         bcf PORTA,4	   ; mem WE down
         nop
         bsf PORTA,4       ; mem WE up

	 movf MEM,W
         movwf LOOPA
DELAY:   btfsc PORTA,2    ;is PC requesting function change?
         goto MODSET      ;yes
         decfsz LOOPA,F
	 goto delay	

         incfsz PORTB,F
         goto WAITADC2
         decfsz PORTC,F
         goto WAITADC2


SENDPC0: movf LIMIT,W
         movwf WADDRH
         clrf WADDRL
         movlw %00010001  ;set mem WE high (bit 4), OE low (bit 5), ADC OE hi (bit 0)
         movwf PORTA

GETLSB0: movf WADDRL,W    ;get lo address
         movwf PORTB
         movf WADDRH,W    ;get hi address
         andlw %01111111  ;clear bit 7
         movwf PORTC
         nop
         movf PORTD,W     ;get data from mem at this address
         movwf MEMLO      ;store it
         movwf MEMHI      ;store it

BRANCH0: btfsc PORTA,2    ;is PC requesting function change?
         goto MODSET      ;yes
         nop
         nop
         movf PORTE,W     ;get PC code
         andlw 7
         movwf CHANGA
         xorwf CHANGE,W
         btfsc STATUS,Z
         goto BRANCH0
         movf CHANGA,W
         movwf CHANGE
         call OUTIT
         iorlw 0          ;affect Z flag (retlw 0 on its own does not set Z)
         btfsc STATUS,Z   ;is W = 0 (step performed) ?
         goto GETLSB0     ;yes
         addlw 1
         btfss STATUS,C   ;is RESET = 255?
         goto BRANCH0     ;no
	 movf MEM,F
	 btfss STATUS,Z
	 goto DX1
         goto DX0

;.............

MODSET: clrf PORTC       ;route from PC command
        movf PORTE,W     ;get PORTE
        goto ROUTE
;..........

RESETP:  goto WAITCLR

MAX0:    clrf MEM          ; normal sampling
         goto WAITCLR

MAX1:	 movlw 10	   ; slow sampling
	 movwf MEM
         goto WAITCLR

MAX2:	 movlw 115	   ; v. slow sampling
	 movwf MEM


WAITCLR: movlw %00011111
         movwf PORTC
WAITCLR2: btfsc PORTA,2
         goto WAITCLR2
         clrf PORTC
         goto INTRPT

;.............

SENDLS3: movf MEMLO,W
         andlw 15         ;put LSB out to PORTB with PC flag (bit 7) high
         iorlw 128        ;NB, PC sees bit 7 as LOW (BUSY line inverted)
         movwf PORTC
         nop
         nop
         retlw 1

SENDMS3: swapf MEMLO,W
         andlw 15         ;put MSB out to PORTB with PC flag (bit 7) low
         movwf PORTC      ;NB, now PC sees bit 7 as HIGH (BUSY line inverted)
         nop
         nop
         retlw 1

SENDLS4: movf MEMHI,W
         andlw 15         ;put LSB out to PORTB with PC flag (bit 7) high
         iorlw 128        ;NB, PC sees bit 7 as LOW (BUSY line inverted)
         movwf PORTC
         nop
         nop
         retlw 1

SENDMS4: swapf MEMHI,W
         andlw 15         ;put MSB out to PORTB with PC flag (bit 7) low
         movwf PORTC      ;NB, now PC sees bit 7 as HIGH (BUSY line inverted)
         nop
         nop
         retlw 1

STEP0:   movlw 8
         movwf DELAYA

DELAY0:  decfsz DELAYA,F
         goto DELAY0
         movlw 1
         addwf WADDRL,F
         btfss STATUS,C
         retlw 0          ;step complete OK
         decfsz WADDRH,F
         retlw 0          ;step complete OK
         retlw 255        ;reset needed, goto start next batch of sampling

;..............

INCRATE: incf FOSC,W      ; not used in P=Spectrum - retained for QB code compatibility 
	 andlw 1
	 movwf FOSC

WAITCLR3: movf FOSC,W
          iorlw %00011110
          movwf PORTC
WAITCLR4: btfsc PORTA,2
          goto WAITCLR4
          clrf PORTC
          goto INTRPT

         .END

